#include "MTGrafPortWindow.h"
#include "MTExceptions.h"
#include "IFileStream.h"
#include "MTApplication.h"

MTGrafPortWindow::MTGrafPortWindow()
{
	theView = nil;
	theWorld = nil;
	portWidth = portHeight = portDepth = 0;
	userPaneDrawProcPtr = nil;
}

MTGrafPortWindow::~MTGrafPortWindow()
{
	if(theWorld)
	{
		UnlockPixels(GetGWorldPixMap(theWorld));
		
		DisposeGWorld(theWorld);
		theWorld = nil;
	}
	
	if(userPaneDrawProcPtr)
	{
		DisposeControlUserPaneDrawUPP(userPaneDrawProcPtr);
		userPaneDrawProcPtr = nil;
	}
}

void MTGrafPortWindow::HandleOpenEvent(void)
{
	UInt32	windowWidth = theWindow->portRect.right - theWindow->portRect.left;
	UInt32	windowHeight = theWindow->portRect.bottom - theWindow->portRect.top;
	SInt32	temp;
	Rect	theRect;
	OSErr	theErr;
	
	GetPortSize(&portWidth, &portHeight);
	portDepth = GetPortDepth();
	
	CreateScrollBars(1, 1);
	
	SetControl32BitMinimum(horzScroll, 0);
	
	temp = portWidth - windowWidth;
	if(temp < 0)
		temp = 0;
	
	SetControl32BitMaximum(horzScroll, temp);
	SetControl32BitValue(horzScroll, 0);
	SetControlViewSize(horzScroll, windowWidth);
	
	SetControl32BitMinimum(vertScroll, 0);
	
	temp = portHeight - windowHeight;
	if(temp < 0)
		temp = 0;
	
	SetControl32BitMaximum(vertScroll, temp);
	SetControl32BitValue(vertScroll, 0);
	SetControlViewSize(vertScroll, windowHeight);
	
	SET_RECT(theRect, 0, 0, windowWidth - kScrollBarSize + 1, windowHeight - kScrollBarSize + 1);
	
	theView = NewControl(theWindow, &theRect, "\p", true, 0, 0, 0, kControlUserPaneProc, 0);
	
	userPaneDrawProcPtr = NewControlUserPaneDrawUPP(UserPaneDrawProc);
	
	SetControlData(theView, kControlEntireControl, kControlUserPaneDrawProcTag, sizeof(ControlUserPaneDrawUPP), &userPaneDrawProcPtr);
	
	SET_RECT(theRect, 0, 0, portWidth, portHeight);
	
	theWorld = nil;
	
	theErr = NewGWorld(&theWorld, portDepth, &theRect, nil, 0, 0);
	if(theErr)
		throw MTOSException(theErr, "Error creating buffer GWorld");
	
	LockPixels(GetGWorldPixMap(theWorld));
	
	DrawToPort(theWorld);
}

void MTGrafPortWindow::HandleCloseEvent(void)
{
	if(theWorld)
	{
		UnlockPixels(GetGWorldPixMap(theWorld));
		
		DisposeGWorld(theWorld);
		theWorld = nil;
	}
}

void MTGrafPortWindow::HandleContentEvent(EventRecord * theEvent, UInt32 flags)
{
	#pragma unused (flags)
	
	if(AutoHandleControls(theEvent))
	{
		
	}
}

void MTGrafPortWindow::HandleResizeEvent(SInt32 newWidth, SInt32 newHeight)
{
	SInt32	temp;
	
	MoveScrollBars(newWidth, newHeight);
	
	SetControl32BitMinimum(horzScroll, 0);
	
	temp = portWidth - newWidth;
	if(temp < 0)
		temp = 0;
	
	SetControl32BitMaximum(horzScroll, temp);
	SetControlViewSize(horzScroll, newWidth);
	
	SetControl32BitMinimum(vertScroll, 0);
	
	temp = portHeight - newHeight;
	if(temp < 0)
		temp = 0;
	
	SetControl32BitMaximum(vertScroll, temp);
	SetControlViewSize(vertScroll, newHeight);
	
	SizeControl(theView, newWidth - kScrollBarSize, newHeight - kScrollBarSize);
	
	Rect	bounds;
	
	bounds.left = 0;
	bounds.top = 0;
	bounds.right = newWidth;
	bounds.bottom = newHeight;
	
	InvalWindowRect(theWindow, &bounds);
}

void MTGrafPortWindow::HandleUpdateEvent(void)
{
	
}

void MTGrafPortWindow::HandleScrollEvent(MTWindowControlType which, SInt32 value)
{
	#pragma unused (which)
	#pragma unused (value)
	
	DrawOneControl(theView);
}

void MTGrafPortWindow::HandleControlEvent(ControlHandle theControl, SInt16 thePart)
{
	#pragma unused (theControl)
	#pragma unused (thePart)
}

void MTGrafPortWindow::HandleButtonEvent(ControlHandle theControl)
{
	#pragma unused (theControl)
}

void MTGrafPortWindow::HandleKeyEvent(EventRecord * theEvent, UInt8 charCode, UInt8 keyCode, EventModifiers modifiers)
{
	#pragma unused (theEvent)
	#pragma unused (charCode)
	#pragma unused (keyCode)
	#pragma unused (modifiers)
}

void MTGrafPortWindow::GetZoomSizeBounds(Rect * bounds)
{
	if((portWidth == 0) || (portHeight == 0) || (portDepth == 0))
	{
		SET_RECT_PTR(bounds, kScrollBarSize * 3, kScrollBarSize * 3, kScrollBarSize * 3, kScrollBarSize * 3);
	}
	else
	{
		SET_RECT_PTR(bounds, kScrollBarSize * 3, kScrollBarSize * 3, portWidth + kScrollBarSize + 1, portHeight + kScrollBarSize + 1);
	}
}

pascal void MTGrafPortWindow::UserPaneDrawProc(ControlHandle theControl, SInt16 part)
{
	#pragma unused (part)
	
	Rect				fromRect, toRect;
	SInt32				xOffset, yOffset, controlWidth, controlHeight;
	MTGrafPortWindow	* data = dynamic_cast<MTGrafPortWindow *>(GetMTWindowFromWindowPtr(GetControlOwner(theControl)));
	Rect				where;
	
	if(data && data->theWorld)
	{
		GetControlBounds(theControl, &where);
		controlWidth = where.right - where.left;
		controlHeight = where.bottom - where.top;
		
		xOffset = GetControl32BitValue(data->horzScroll);
		yOffset = GetControl32BitValue(data->vertScroll);
		
		SET_RECT(fromRect, xOffset, yOffset, xOffset + controlWidth, yOffset + controlHeight);
		if(fromRect.right > data->portWidth)
			fromRect.right = data->portWidth;
		if(fromRect.bottom > data->portHeight)
			fromRect.bottom = data->portHeight;
		
		toRect = fromRect;
		OffsetRect(&toRect, -toRect.left, -toRect.top);
		OffsetRect(&toRect, data->theWindow->portRect.left, data->theWindow->portRect.top);
		
		CopyBits((BitMapPtr)*data->theWorld->portPixMap, (BitMapPtr)*((CGrafPtr)(data->theWindow))->portPixMap, &fromRect, &toRect, srcCopy, nil);
	}
}

void MTGrafPortWindow::GetWindowSize(Rect * theRect)
{
	GetPortSize(&portWidth, &portHeight);
	portDepth = GetPortDepth();
	
	SInt32	tempWidth, tempHeight;
	
	tempWidth = portWidth;
	if(tempWidth < kScrollBarSize * 4)
		tempWidth = kScrollBarSize * 4;
	
	tempHeight = portHeight;
	if(tempHeight < kScrollBarSize * 4)
		tempHeight = kScrollBarSize * 4;
	
	SET_RECT_PTR(theRect, 0, 0, tempWidth + kScrollBarSize, tempHeight + kScrollBarSize);
}

void MTGrafPortWindow::GetWindowStandardSize(Rect * theRect)
{
	GetPortSize(&portWidth, &portHeight);
	portDepth = GetPortDepth();
	
	SInt32	tempWidth, tempHeight;
	
	tempWidth = portWidth;
	if(tempWidth < kScrollBarSize * 4)
		tempWidth = kScrollBarSize * 4;
	
	tempHeight = portHeight;
	if(tempHeight < kScrollBarSize * 4)
		tempHeight = kScrollBarSize * 4;
	
	SET_RECT_PTR(theRect, 6, 42, tempWidth + 6 + kScrollBarSize, tempHeight + 42 + kScrollBarSize);
}

void MTGrafPortWindow::ExportAsPicture(const char * name)
{
	char				buf[256];
	Str255				theString;
	StandardFileReply	reply;
	OSErr				theErr;
	
	if(name)
		std::sprintf(buf, "%s.pict", name);
	else
		std::strcpy(buf, "<unnamed>.pict");
	
	CopyCStringToPascal(buf, theString);
	
	StandardPutFile("\pExport Picture:", theString, &reply);
	
	if(reply.sfGood)
	{
		if(reply.sfReplacing)
		{
			theErr = FSpDelete(&reply.sfFile);
			if(theErr)
				throw MTOSFileException(theErr, "Error deleting old file");
		}
		
		theErr = FSpCreate(&reply.sfFile, 'ONIt', 'PICT', reply.sfScript);
		if(theErr)
			throw MTOSFileException(theErr, "Error creating file");
		
		PicHandle	thePicture;
		
		{
			RgnHandle	saveRgn;
			CGrafPtr	savePort;
			GDHandle	saveDevice;
			
			GetGWorld(&savePort, &saveDevice);
			SetGWorld(theWorld, nil);
			
			saveRgn = NewRgn();
			GetClip(saveRgn);
			ClipRect(&theWorld->portRect);
			
			thePicture = OpenPicture(&theWorld->portRect);
			
			CopyBits((BitMapPtr)*theWorld->portPixMap, (BitMapPtr)*theWorld->portPixMap, &theWorld->portRect, &theWorld->portRect, srcCopy, nil);
			
			ClosePicture();
			
			SetClip(saveRgn);
			DisposeRgn(saveRgn);
			
			SetGWorld(savePort, saveDevice);
		}
		
		{
			IFileStream	outStream;
			UInt8		* emptyBuf = (UInt8 *)NewPtrClear(512);
			
			outStream.OpenFile(&reply.sfFile);
			
			outStream.WriteBuffer(emptyBuf, 512);
			
			HLock((Handle)thePicture);
			outStream.WriteBuffer((UInt8 *)*thePicture, GetHandleSize((Handle)thePicture));
			HUnlock((Handle)thePicture);
			
			outStream.CloseFile();
			
			DisposePtr((Ptr)emptyBuf);
		}
		
		KillPicture(thePicture);
	}
}